package org.kodein.emoji.objects.sound

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PostalHorn: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📯",
        description = "postal horn",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("postal-horn", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: sound: postal horn.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PostalHorn: Emoji get() = _PostalHorn
