package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FamilyManBoy: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👨‍👦",
        description = "family: man, boy",
        unicodeVersion = UnicodeVersion(4, 0),
        aliases = listOf("family-man-boy", ),
        emoticons = listOf(),
        notoImageRatio = 0.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji People & Body: family: family: man, boy.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FamilyManBoy: Emoji get() = _FamilyManBoy
