package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone2Emoji
import org.kodein.emoji.SkinTone2EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PeopleHoldingHands: SkinTone2Emoji = SkinTone2EmojiImpl(
    details = Emoji.Details(
        string = "🧑‍🤝‍🧑",
        description = "people holding hands",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("people-holding-hands", "holding-hands"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk21c = 2,
    sk22c = 8,
)

/**
 * Emoji People & Body: family: people holding hands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PeopleHoldingHands: SkinTone2Emoji get() = _PeopleHoldingHands

/**
 * Alias to emoji [PeopleHoldingHands] (People & Body: family: people holding hands).
*/
public val Emoji.Companion.HoldingHands: SkinTone2Emoji get() = _PeopleHoldingHands
