package org.kodein.emoji.people_body.hand_single_finger

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _BackhandIndexPointingUp: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "👆",
        description = "backhand index pointing up",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("backhand-index-pointing-up", "point-up"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hand-single-finger: backhand index pointing up.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BackhandIndexPointingUp: SkinTone1Emoji get() = _BackhandIndexPointingUp

/**
 * Alias to emoji [BackhandIndexPointingUp] (People & Body: hand-single-finger: backhand index pointing up).
*/
public val Emoji.Companion.PointUp: SkinTone1Emoji get() = _BackhandIndexPointingUp
