package org.kodein.emoji.people_body.person

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPerson() {
    add(intArrayOf(0x1f476), _Baby)
    addVariations(intArrayOf(0x1f476, 0x0), _Baby, 1)
    add(intArrayOf(0x1f9d2), _Child)
    addVariations(intArrayOf(0x1f9d2, 0x0), _Child, 1)
    add(intArrayOf(0x1f466), _Boy)
    addVariations(intArrayOf(0x1f466, 0x0), _Boy, 1)
    add(intArrayOf(0x1f467), _Girl)
    addVariations(intArrayOf(0x1f467, 0x0), _Girl, 1)
    add(intArrayOf(0x1f9d1), _Person)
    addVariations(intArrayOf(0x1f9d1, 0x0), _Person, 1)
    add(intArrayOf(0x1f471), _PersonBlondHair)
    addVariations(intArrayOf(0x1f471, 0x0), _PersonBlondHair, 1)
    add(intArrayOf(0x1f468), _Man)
    addVariations(intArrayOf(0x1f468, 0x0), _Man, 1)
    add(intArrayOf(0x1f9d4), _PersonBeard)
    addVariations(intArrayOf(0x1f9d4, 0x0), _PersonBeard, 1)
    add(intArrayOf(0x1f9d4, 0x200d, 0x2642), _ManBeard)
    addVariations(intArrayOf(0x1f9d4, 0x0, 0x200d, 0x2642), _ManBeard, 1)
    add(intArrayOf(0x1f9d4, 0x200d, 0x2642, 0xfe0f), _ManBeard)
    addVariations(intArrayOf(0x1f9d4, 0x0, 0x200d, 0x2642, 0xfe0f), _ManBeard, 1)
    add(intArrayOf(0x1f9d4, 0x200d, 0x2640), _WomanBeard)
    addVariations(intArrayOf(0x1f9d4, 0x0, 0x200d, 0x2640), _WomanBeard, 1)
    add(intArrayOf(0x1f9d4, 0x200d, 0x2640, 0xfe0f), _WomanBeard)
    addVariations(intArrayOf(0x1f9d4, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanBeard, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f9b0), _ManRedHair)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f9b0), _ManRedHair, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f9b1), _ManCurlyHair)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f9b1), _ManCurlyHair, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f9b3), _ManWhiteHair)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f9b3), _ManWhiteHair, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f9b2), _ManBald)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f9b2), _ManBald, 1)
    add(intArrayOf(0x1f469), _Woman)
    addVariations(intArrayOf(0x1f469, 0x0), _Woman, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f9b0), _WomanRedHair)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f9b0), _WomanRedHair, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9b0), _PersonRedHair)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f9b0), _PersonRedHair, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f9b1), _WomanCurlyHair)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f9b1), _WomanCurlyHair, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9b1), _PersonCurlyHair)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f9b1), _PersonCurlyHair, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f9b3), _WomanWhiteHair)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f9b3), _WomanWhiteHair, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9b3), _PersonWhiteHair)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f9b3), _PersonWhiteHair, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f9b2), _WomanBald)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f9b2), _WomanBald, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9b2), _PersonBald)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f9b2), _PersonBald, 1)
    add(intArrayOf(0x1f471, 0x200d, 0x2640), _WomanBlondHair)
    addVariations(intArrayOf(0x1f471, 0x0, 0x200d, 0x2640), _WomanBlondHair, 1)
    add(intArrayOf(0x1f471, 0x200d, 0x2640, 0xfe0f), _WomanBlondHair)
    addVariations(intArrayOf(0x1f471, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanBlondHair, 1)
    add(intArrayOf(0x1f471, 0x200d, 0x2642), _ManBlondHair)
    addVariations(intArrayOf(0x1f471, 0x0, 0x200d, 0x2642), _ManBlondHair, 1)
    add(intArrayOf(0x1f471, 0x200d, 0x2642, 0xfe0f), _ManBlondHair)
    addVariations(intArrayOf(0x1f471, 0x0, 0x200d, 0x2642, 0xfe0f), _ManBlondHair, 1)
    add(intArrayOf(0x1f9d3), _OlderPerson)
    addVariations(intArrayOf(0x1f9d3, 0x0), _OlderPerson, 1)
    add(intArrayOf(0x1f474), _OldMan)
    addVariations(intArrayOf(0x1f474, 0x0), _OldMan, 1)
    add(intArrayOf(0x1f475), _OldWoman)
    addVariations(intArrayOf(0x1f475, 0x0), _OldWoman, 1)
}

internal suspend fun SequenceScope<Emoji>.yieldAllPerson() {
    yield(_Baby)
    yield(_Child)
    yield(_Boy)
    yield(_Girl)
    yield(_Person)
    yield(_PersonBlondHair)
    yield(_Man)
    yield(_PersonBeard)
    yield(_ManBeard)
    yield(_WomanBeard)
    yield(_ManRedHair)
    yield(_ManCurlyHair)
    yield(_ManWhiteHair)
    yield(_ManBald)
    yield(_Woman)
    yield(_WomanRedHair)
    yield(_PersonRedHair)
    yield(_WomanCurlyHair)
    yield(_PersonCurlyHair)
    yield(_WomanWhiteHair)
    yield(_PersonWhiteHair)
    yield(_WomanBald)
    yield(_PersonBald)
    yield(_WomanBlondHair)
    yield(_ManBlondHair)
    yield(_OlderPerson)
    yield(_OldMan)
    yield(_OldWoman)
}

internal val countPerson = 28

/**
 * All Emoji of the People & Body: person subgroup.
*/
public fun Emoji.Companion.sequencePerson(): Sequence<Emoji> =
    sequence { yieldAllPerson() }

/**
 * All Emoji of the People & Body: person subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listPerson(): List<Emoji> =
    ArrayList<Emoji>(countPerson).also { list -> sequencePerson().forEach { list.add(it) } }

@Deprecated("Renamed listPerson.", replaceWith = ReplaceWith("listPerson()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allPerson(): List<Emoji> =
    listPerson()
