package org.kodein.emoji.people_body.person_gesture

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonShrugging: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🤷",
        description = "person shrugging",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("person-shrugging", "shrug"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-gesture: person shrugging.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonShrugging: SkinTone1Emoji get() = _PersonShrugging

/**
 * Alias to emoji [PersonShrugging] (People & Body: person-gesture: person shrugging).
*/
public val Emoji.Companion.Shrug: SkinTone1Emoji get() = _PersonShrugging
