package org.kodein.emoji.people_body.person_role

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonInTuxedo: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🤵",
        description = "person in tuxedo",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("person-in-tuxedo", "tuxedo"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-role: person in tuxedo.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonInTuxedo: SkinTone1Emoji get() = _PersonInTuxedo

/**
 * Alias to emoji [PersonInTuxedo] (People & Body: person-role: person in tuxedo).
*/
public val Emoji.Companion.Tuxedo: SkinTone1Emoji get() = _PersonInTuxedo
