package org.kodein.emoji.people_body.person_sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.UnqualifiedSkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PersonBouncingBall: SkinTone1Emoji = UnqualifiedSkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "⛹️",
        description = "person bouncing ball",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("person-bouncing-ball", "bouncing-ball"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    uqString = "⛹",
    sk1c = 1,
)

/**
 * Emoji People & Body: person-sport: person bouncing ball.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonBouncingBall: SkinTone1Emoji get() = _PersonBouncingBall

/**
 * Alias to emoji [PersonBouncingBall] (People & Body: person-sport: person bouncing ball).
*/
public val Emoji.Companion.BouncingBall: SkinTone1Emoji get() = _PersonBouncingBall
