package org.kodein.emoji.people_body.person_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BustsInSilhouette: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👥",
        description = "busts in silhouette",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("busts-in-silhouette", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji People & Body: person-symbol: busts in silhouette.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BustsInSilhouette: Emoji get() = _BustsInSilhouette
