package org.kodein.emoji.smileys_emotion.cat_face

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CatWithWrySmile: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😼",
        description = "cat with wry smile",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("cat-with-wry-smile", "smirk-cat"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: cat-face: cat with wry smile.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CatWithWrySmile: Emoji get() = _CatWithWrySmile

/**
 * Alias to emoji [CatWithWrySmile] (Smileys & Emotion: cat-face: cat with wry smile).
*/
public val Emoji.Companion.SmirkCat: Emoji get() = _CatWithWrySmile
