package org.kodein.emoji.smileys_emotion.cat_face

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WearyCat: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🙀",
        description = "weary cat",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("weary-cat", "scream-cat"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: cat-face: weary cat.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WearyCat: Emoji get() = _WearyCat

/**
 * Alias to emoji [WearyCat] (Smileys & Emotion: cat-face: weary cat).
*/
public val Emoji.Companion.ScreamCat: Emoji get() = _WearyCat
