package org.kodein.emoji.smileys_emotion.face_affection

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceBlowingAKiss: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😘",
        description = "face blowing a kiss",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("face-blowing-a-kiss", "kissing-heart"),
        emoticons = listOf(";*"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-affection: face blowing a kiss.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceBlowingAKiss: Emoji get() = _FaceBlowingAKiss

/**
 * Alias to emoji [FaceBlowingAKiss] (Smileys & Emotion: face-affection: face blowing a kiss).
*/
public val Emoji.Companion.KissingHeart: Emoji get() = _FaceBlowingAKiss
