package org.kodein.emoji.smileys_emotion.face_affection

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SmilingFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "☺️",
        description = "smiling face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("smiling-face", "warm-smile"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-affection: smiling face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SmilingFace: Emoji get() = _SmilingFace

/**
 * Alias to emoji [SmilingFace] (Smileys & Emotion: face-affection: smiling face).
*/
public val Emoji.Companion.WarmSmile: Emoji get() = _SmilingFace
