package org.kodein.emoji.smileys_emotion.face_affection

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFaceAffection() {
    add(intArrayOf(0x1f970), _SmilingFaceWithHearts)
    add(intArrayOf(0x1f60d), _SmilingFaceWithHeartEyes)
    add(intArrayOf(0x1f929), _StarStruck)
    add(intArrayOf(0x1f618), _FaceBlowingAKiss)
    add(intArrayOf(0x1f617), _KissingFace)
    add(intArrayOf(0x263a, 0xfe0f), _SmilingFace)
    add(intArrayOf(0x263a), _SmilingFace)
    add(intArrayOf(0x1f61a), _KissingFaceWithClosedEyes)
    add(intArrayOf(0x1f619), _KissingFaceWithSmilingEyes)
    add(intArrayOf(0x1f972), _SmilingFaceWithTear)
}

internal suspend fun SequenceScope<Emoji>.yieldAllFaceAffection() {
    yield(_SmilingFaceWithHearts)
    yield(_SmilingFaceWithHeartEyes)
    yield(_StarStruck)
    yield(_FaceBlowingAKiss)
    yield(_KissingFace)
    yield(_SmilingFace)
    yield(_KissingFaceWithClosedEyes)
    yield(_KissingFaceWithSmilingEyes)
    yield(_SmilingFaceWithTear)
}

internal val countFaceAffection = 9

/**
 * All Emoji of the Smileys & Emotion: face-affection subgroup.
*/
public fun Emoji.Companion.sequenceFaceAffection(): Sequence<Emoji> =
    sequence { yieldAllFaceAffection() }

/**
 * All Emoji of the Smileys & Emotion: face-affection subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listFaceAffection(): List<Emoji> =
    ArrayList<Emoji>(countFaceAffection).also { list -> sequenceFaceAffection().forEach { list.add(it) } }

@Deprecated("Renamed listFaceAffection.", replaceWith = ReplaceWith("listFaceAffection()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allFaceAffection(): List<Emoji> =
    listFaceAffection()
