package org.kodein.emoji.smileys_emotion.face_neutral_skeptical

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ShakingFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🫨",
        description = "shaking face",
        unicodeVersion = UnicodeVersion(15, 0),
        aliases = listOf("shaking-face", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-neutral-skeptical: shaking face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ShakingFace: Emoji get() = _ShakingFace
