package org.kodein.emoji.smileys_emotion.face_smiling

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BeamingFaceWithSmilingEyes: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😁",
        description = "beaming face with smiling eyes",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("beaming-face-with-smiling-eyes", "grinning"),
        emoticons = listOf("*^_^*"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-smiling: beaming face with smiling eyes.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BeamingFaceWithSmilingEyes: Emoji get() = _BeamingFaceWithSmilingEyes

/**
 * Alias to emoji [BeamingFaceWithSmilingEyes] (Smileys & Emotion: face-smiling: beaming face with smiling eyes).
*/
public val Emoji.Companion.Grinning: Emoji get() = _BeamingFaceWithSmilingEyes
