package org.kodein.emoji.smileys_emotion.face_smiling

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GrinningFaceWithBigEyes: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😃",
        description = "grinning face with big eyes",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("grinning-face-with-big-eyes", "smile-with-big-eyes"),
        emoticons = listOf(":-D"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-smiling: grinning face with big eyes.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GrinningFaceWithBigEyes: Emoji get() = _GrinningFaceWithBigEyes

/**
 * Alias to emoji [GrinningFaceWithBigEyes] (Smileys & Emotion: face-smiling: grinning face with big eyes).
*/
public val Emoji.Companion.SmileWithBigEyes: Emoji get() = _GrinningFaceWithBigEyes
