package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BlackHeart: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🖤",
        description = "black heart",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("black-heart", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: black heart.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BlackHeart: Emoji get() = _BlackHeart
