package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GreyHeart: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🩶",
        description = "grey heart",
        unicodeVersion = UnicodeVersion(15, 0),
        aliases = listOf("grey-heart", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: grey heart.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GreyHeart: Emoji get() = _GreyHeart
