package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PinkHeart: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🩷",
        description = "pink heart",
        unicodeVersion = UnicodeVersion(15, 0),
        aliases = listOf("pink-heart", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: pink heart.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PinkHeart: Emoji get() = _PinkHeart
