package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CoolButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🆒",
        description = "COOL button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("cool-button", "cool"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Symbols: alphanum: COOL button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CoolButton: Emoji get() = _CoolButton

/**
 * Alias to emoji [CoolButton] (Symbols: alphanum: COOL button).
*/
public val Emoji.Companion.Cool: Emoji get() = _CoolButton
