package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _JapaneseAcceptableButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🉑",
        description = "Japanese “acceptable” button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("japanese-acceptable-button", "accept"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: alphanum: Japanese “acceptable” button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.JapaneseAcceptableButton: Emoji get() = _JapaneseAcceptableButton

/**
 * Alias to emoji [JapaneseAcceptableButton] (Symbols: alphanum: Japanese “acceptable” button).
*/
public val Emoji.Companion.Accept: Emoji get() = _JapaneseAcceptableButton
