package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🅿️",
        description = "P button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("p-button", "parking"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: alphanum: P button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PButton: Emoji get() = _PButton

/**
 * Alias to emoji [PButton] (Symbols: alphanum: P button).
*/
public val Emoji.Companion.Parking: Emoji get() = _PButton
