package org.kodein.emoji.symbols.arrow

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RightArrowCurvingUp: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⤴️",
        description = "right arrow curving up",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("right-arrow-curving-up", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: arrow: right arrow curving up.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RightArrowCurvingUp: Emoji get() = _RightArrowCurvingUp
