package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LastTrackButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⏮️",
        description = "last track button",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("last-track-button", "previous", "left-pointing-double-triangle-with-vertical-bar"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: av-symbol: last track button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LastTrackButton: Emoji get() = _LastTrackButton

/**
 * Alias to emoji [LastTrackButton] (Symbols: av-symbol: last track button).
*/
public val Emoji.Companion.Previous: Emoji get() = _LastTrackButton

/**
 * Alias to emoji [LastTrackButton] (Symbols: av-symbol: last track button).
*/
public val Emoji.Companion.LeftPointingDoubleTriangleWithVerticalBar: Emoji get() = _LastTrackButton
