package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _UpwardsButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔼",
        description = "upwards button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("upwards-button", "upwards", "arrow-up", "triangle-up"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: av-symbol: upwards button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.UpwardsButton: Emoji get() = _UpwardsButton

/**
 * Alias to emoji [UpwardsButton] (Symbols: av-symbol: upwards button).
*/
public val Emoji.Companion.Upwards: Emoji get() = _UpwardsButton

/**
 * Alias to emoji [UpwardsButton] (Symbols: av-symbol: upwards button).
*/
public val Emoji.Companion.ArrowUp: Emoji get() = _UpwardsButton

/**
 * Alias to emoji [UpwardsButton] (Symbols: av-symbol: upwards button).
*/
public val Emoji.Companion.TriangleUp: Emoji get() = _UpwardsButton
