package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BlackCircle: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⚫",
        description = "black circle",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("black-circle", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: geometric: black circle.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BlackCircle: Emoji get() = _BlackCircle
