package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BlackMediumSmallSquare: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "◾",
        description = "black medium-small square",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("black-medium-small-square", "black-square-medium-small"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: geometric: black medium-small square.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BlackMediumSmallSquare: Emoji get() = _BlackMediumSmallSquare

/**
 * Alias to emoji [BlackMediumSmallSquare] (Symbols: geometric: black medium-small square).
*/
public val Emoji.Companion.BlackSquareMediumSmall: Emoji get() = _BlackMediumSmallSquare
