package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _OrangeSquare: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🟧",
        description = "orange square",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("orange-square", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: geometric: orange square.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OrangeSquare: Emoji get() = _OrangeSquare
