package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RedTrianglePointedDown: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔻",
        description = "red triangle pointed down",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("red-triangle-pointed-down", "triangle-pointed-down"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: geometric: red triangle pointed down.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RedTrianglePointedDown: Emoji get() = _RedTrianglePointedDown

/**
 * Alias to emoji [RedTrianglePointedDown] (Symbols: geometric: red triangle pointed down).
*/
public val Emoji.Companion.TrianglePointedDown: Emoji get() = _RedTrianglePointedDown
