package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WhiteCircle: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⚪",
        description = "white circle",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("white-circle", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: geometric: white circle.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WhiteCircle: Emoji get() = _WhiteCircle
