package org.kodein.emoji.symbols.keycap

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _KeycapHash: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "#️⃣",
        description = "keycap: #",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("keycap-", "-", "number-sign"),
        emoticons = listOf(),
        notoImageRatio = 0.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: keycap: keycap: #.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.KeycapHash: Emoji get() = _KeycapHash

/**
 * Alias to emoji [KeycapHash] (Symbols: keycap: keycap: #).
*/
public val Emoji.Companion.NumberSign: Emoji get() = _KeycapHash
