package org.kodein.emoji.symbols.punctuation

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DoubleExclamationMark: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "‼️",
        description = "double exclamation mark",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("double-exclamation-mark", "exclamation-double", "-"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Symbols: punctuation: double exclamation mark.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DoubleExclamationMark: Emoji get() = _DoubleExclamationMark

/**
 * Alias to emoji [DoubleExclamationMark] (Symbols: punctuation: double exclamation mark).
*/
public val Emoji.Companion.ExclamationDouble: Emoji get() = _DoubleExclamationMark
