package org.kodein.emoji.symbols.religion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DottedSixPointedStar: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔯",
        description = "dotted six-pointed star",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("dotted-six-pointed-star", "star-of-david-with-dot"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: religion: dotted six-pointed star.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DottedSixPointedStar: Emoji get() = _DottedSixPointedStar

/**
 * Alias to emoji [DottedSixPointedStar] (Symbols: religion: dotted six-pointed star).
*/
public val Emoji.Companion.StarOfDavidWithDot: Emoji get() = _DottedSixPointedStar
