package org.kodein.emoji.symbols.religion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _OrthodoxCross: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "☦️",
        description = "orthodox cross",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("orthodox-cross", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: religion: orthodox cross.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OrthodoxCross: Emoji get() = _OrthodoxCross
