package org.kodein.emoji.symbols.religion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _StarAndCrescent: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "☪️",
        description = "star and crescent",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("star-and-crescent", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: religion: star and crescent.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.StarAndCrescent: Emoji get() = _StarAndCrescent
