package org.kodein.emoji.symbols.religion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WheelOfDharma: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "☸️",
        description = "wheel of dharma",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("wheel-of-dharma", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: religion: wheel of dharma.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WheelOfDharma: Emoji get() = _WheelOfDharma
