package org.kodein.emoji.symbols.transport_sign

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllTransportSign() {
    add(intArrayOf(0x1f3e7), _AtmSign)
    add(intArrayOf(0x1f6ae), _LitterInBinSign)
    add(intArrayOf(0x1f6b0), _PotableWater)
    add(intArrayOf(0x267f), _WheelchairSymbol)
    add(intArrayOf(0x1f6b9), _MensRoom)
    add(intArrayOf(0x1f6ba), _WomensRoom)
    add(intArrayOf(0x1f6bb), _Restroom)
    add(intArrayOf(0x1f6bc), _BabySymbol)
    add(intArrayOf(0x1f6be), _WaterCloset)
    add(intArrayOf(0x1f6c2), _PassportControl)
    add(intArrayOf(0x1f6c3), _Customs)
    add(intArrayOf(0x1f6c4), _BaggageClaim)
    add(intArrayOf(0x1f6c5), _LeftLuggage)
}

internal suspend fun SequenceScope<Emoji>.yieldAllTransportSign() {
    yield(_AtmSign)
    yield(_LitterInBinSign)
    yield(_PotableWater)
    yield(_WheelchairSymbol)
    yield(_MensRoom)
    yield(_WomensRoom)
    yield(_Restroom)
    yield(_BabySymbol)
    yield(_WaterCloset)
    yield(_PassportControl)
    yield(_Customs)
    yield(_BaggageClaim)
    yield(_LeftLuggage)
}

internal val countTransportSign = 13

/**
 * All Emoji of the Symbols: transport-sign subgroup.
*/
public fun Emoji.Companion.sequenceTransportSign(): Sequence<Emoji> =
    sequence { yieldAllTransportSign() }

/**
 * All Emoji of the Symbols: transport-sign subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listTransportSign(): List<Emoji> =
    ArrayList<Emoji>(countTransportSign).also { list -> sequenceTransportSign().forEach { list.add(it) } }

@Deprecated("Renamed listTransportSign.", replaceWith = ReplaceWith("listTransportSign()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allTransportSign(): List<Emoji> =
    listTransportSign()
