package org.kodein.emoji.symbols.warning

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NoEntry: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⛔",
        description = "no entry",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("no-entry", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: warning: no entry.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NoEntry: Emoji get() = _NoEntry
