package org.kodein.emoji.symbols.warning

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NoSmoking: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚭",
        description = "no smoking",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("no-smoking", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: warning: no smoking.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NoSmoking: Emoji get() = _NoSmoking
