package org.kodein.emoji.symbols.zodiac

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllZodiac() {
    add(intArrayOf(0x2648), _Aries)
    add(intArrayOf(0x2649), _Taurus)
    add(intArrayOf(0x264a), _Gemini)
    add(intArrayOf(0x264b), _Cancer)
    add(intArrayOf(0x264c), _Leo)
    add(intArrayOf(0x264d), _Virgo)
    add(intArrayOf(0x264e), _Libra)
    add(intArrayOf(0x264f), _Scorpio)
    add(intArrayOf(0x2650), _Sagittarius)
    add(intArrayOf(0x2651), _Capricorn)
    add(intArrayOf(0x2652), _Aquarius)
    add(intArrayOf(0x2653), _Pisces)
    add(intArrayOf(0x26ce), _Ophiuchus)
}

internal suspend fun SequenceScope<Emoji>.yieldAllZodiac() {
    yield(_Aries)
    yield(_Taurus)
    yield(_Gemini)
    yield(_Cancer)
    yield(_Leo)
    yield(_Virgo)
    yield(_Libra)
    yield(_Scorpio)
    yield(_Sagittarius)
    yield(_Capricorn)
    yield(_Aquarius)
    yield(_Pisces)
    yield(_Ophiuchus)
}

internal val countZodiac = 13

/**
 * All Emoji of the Symbols: zodiac subgroup.
*/
public fun Emoji.Companion.sequenceZodiac(): Sequence<Emoji> =
    sequence { yieldAllZodiac() }

/**
 * All Emoji of the Symbols: zodiac subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listZodiac(): List<Emoji> =
    ArrayList<Emoji>(countZodiac).also { list -> sequenceZodiac().forEach { list.add(it) } }

@Deprecated("Renamed listZodiac.", replaceWith = ReplaceWith("listZodiac()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allZodiac(): List<Emoji> =
    listZodiac()
