package org.kodein.emoji.travel_places.place_building

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _StatueOfLiberty: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🗽",
        description = "Statue of Liberty",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("statue-of-liberty", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: place-building: Statue of Liberty.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.StatueOfLiberty: Emoji get() = _StatueOfLiberty
