package org.kodein.emoji.travel_places.place_building

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TokyoTower: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🗼",
        description = "Tokyo tower",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("tokyo-tower", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: place-building: Tokyo tower.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TokyoTower: Emoji get() = _TokyoTower
