package org.kodein.emoji.travel_places.place_other

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CityscapeAtDusk: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌆",
        description = "cityscape at dusk",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("cityscape-at-dusk", "sunset-cityscape"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: place-other: cityscape at dusk.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CityscapeAtDusk: Emoji get() = _CityscapeAtDusk

/**
 * Alias to emoji [CityscapeAtDusk] (Travel & Places: place-other: cityscape at dusk).
*/
public val Emoji.Companion.SunsetCityscape: Emoji get() = _CityscapeAtDusk
