package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CrescentMoon: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌙",
        description = "crescent moon",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("crescent-moon", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: crescent moon.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CrescentMoon: Emoji get() = _CrescentMoon
