package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NewMoonFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌚",
        description = "new moon face",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("new-moon-face", "moon-face-new"),
        emoticons = listOf(">_>"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: new moon face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NewMoonFace: Emoji get() = _NewMoonFace

/**
 * Alias to emoji [NewMoonFace] (Travel & Places: sky & weather: new moon face).
*/
public val Emoji.Companion.MoonFaceNew: Emoji get() = _NewMoonFace
