package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WaxingGibbousMoon: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌔",
        description = "waxing gibbous moon",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("waxing-gibbous-moon", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: waxing gibbous moon.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WaxingGibbousMoon: Emoji get() = _WaxingGibbousMoon
