package org.kodein.emoji.travel_places.transport_ground

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _OncomingTaxi: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚖",
        description = "oncoming taxi",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("oncoming-taxi", "taxi-front"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: transport-ground: oncoming taxi.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OncomingTaxi: Emoji get() = _OncomingTaxi

/**
 * Alias to emoji [OncomingTaxi] (Travel & Places: transport-ground: oncoming taxi).
*/
public val Emoji.Companion.TaxiFront: Emoji get() = _OncomingTaxi
