package org.kodein.emoji.people_body.hand_fingers_open

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _RaisedBackOfHand: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🤚",
        description = "raised back of hand",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("raised-back-of-hand", "back-hand"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hand-fingers-open: raised back of hand.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RaisedBackOfHand: SkinTone1Emoji get() = _RaisedBackOfHand

/**
 * Alias to emoji [RaisedBackOfHand] (People & Body: hand-fingers-open: raised back of hand).
*/
public val Emoji.Companion.BackHand: SkinTone1Emoji get() = _RaisedBackOfHand
