package org.kodein.emoji.smileys_emotion.cat_face

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SmilingCatWithHeartEyes: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😻",
        description = "smiling cat with heart-eyes",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("smiling-cat-with-heart-eyes", "heart-eyes-cat"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: cat-face: smiling cat with heart-eyes.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SmilingCatWithHeartEyes: Emoji get() = _SmilingCatWithHeartEyes

/**
 * Alias to emoji [SmilingCatWithHeartEyes] (Smileys & Emotion: cat-face: smiling cat with heart-eyes).
*/
public val Emoji.Companion.HeartEyesCat: Emoji get() = _SmilingCatWithHeartEyes
